/****************************************************************************
*                                                                           *
* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY     *
* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE       *
* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR     *
* PURPOSE.                                                                  *
*                                                                           *
* Copyright(C) 1997-98 by PSH //UCL.                                        *
*                                                                           *
*****************************************************************************
*                                                                           *
* This is HASP Emulator functions of Soft-Pro HASP Emulator                 *
*                                                                           *
****************************************************************************/
#include<windows.h>

// if Win95...
#ifdef HASP_EMU_95
#include <basedef.h>
#include <vmm.h>

#pragma VxD_LOCKED_CODE_SEG
#pragma VxD_LOCKED_DATA_SEG

#endif

#include "haspfile.h"
#include "haspdata.h"
#include "hasp-emu.h"
#include "fileio.h"
#include "emuver.h"

// HASP Dump Header
extern EMU_HASP_DATA *HASPHeader;

// HASP Memory
extern unsigned short int *HASPMem;

extern char *DUMPFile;
extern char *DUMP;
extern char *DUMPPath;


void HASP_EMU(HASPData *HASP)
{

int Opened=-1;
unsigned int Seed,Block;
unsigned short int NetSize;
unsigned short int HASPSeeds[3];
DWORD Type;
DWORD Size;

// For Debug
EMUBreak();

// HASP API Dispatch
switch((HASP->Service & 0xFFFF))
	{

	// LOCALHASP_ISHASP	
	// Par1,2,3 must be 0 !
	case 1: HASP->Par1=1;HASP->Par2=HASP->Par3=HASP->Par4=0;break;
	
	// LOCALHASP_HASPCODE
	case 2:
	case 41:

		// Undoc fn.
		if (HASP->Pass1 == 0 && HASP->Pass2 == 0)
		{

/***************************************************************************
* Bug Here !                                                               *
****************************************************************************
* It's part of seed table                                                  *
***************************************************************************/

		HASP->Par1=0xBB58;
		HASP->Par2=0xE11F;
		HASP->Par3=0x7A86;
		HASP->Par4=0xDCD9;
		}
		else

		// It's not need (it's default)
		if (HASP->Pass1 == 5 && HASP->Pass2 == 5)
			HASP->Par1=HASP->Par2=HASP->Par3=HASP->Par4=0;
			else
			{

			// Read Header
			Opened=ReadHeader(HASP->Pass1,HASP->Pass2);
			if (Opened != -1)
				{

				// HASP with Bug ?
				if (HASPHeader->MaxSeed==0x7FFF)
					Seed=HASP->Seed & 0x7FFF;
					else
					Seed=HASP->Seed;

				// Read Seeds
				if (EMUReadFile(Opened,8,sizeof(EMU_HASP_DATA)+Seed*8,(unsigned char *)&HASPSeeds) == -1)
					HASP->Par1=HASP->Par2=HASP->Par3=HASP->Par4=0;
					else
					{
					HASP->Par1=HASPSeeds[0];
					HASP->Par2=HASPSeeds[1];
					HASP->Par3=HASPSeeds[2];
					HASP->Par4=HASPSeeds[3];
					}
				}
				else
				// default
				HASP->Par1=HASP->Par2=HASP->Par3=HASP->Par4=0;			
			}
   	        break;

	// MEMOHASP_READWORD
	// NETHASP_READMEMO
	case 3: // Read Header
	case 44:Opened=ReadHeader(HASP->Pass1,HASP->Pass2);
			if (Opened != -1)
				{
				// Undoc fn
				if (HASP->Par1== 0xFFFF)
					{
					HASP->Par2=0xFFFE;
					HASP->Par3=0;
					HASP->Par4=HASP->Pass1;
					break;
					}
				// Undoc fn. (Read NetHASP users)
				if (HASP->Par1== 0xFFFD)
					{
					if (HASPHeader->NetHASP==0)
						HASP->Par2=0;
						else
						HASP->Par2=HASPHeader->NetHASP;
					HASP->Par3=0;
					HASP->Par4=HASP->Pass2;
					break;
					}

				// Param Check
				if (HASP->Par1 > HASPHeader->MemSize/2)
						{
						HASP->Par1=HASP->Par2=HASP->Par4=0;
						HASP->Par3=(unsigned short int)-2;
						break;
						}
				// Read Memory
				if (ReadMemory(Opened) != 0)
						{
						HASP->Par1=HASP->Par2=HASP->Par4=0;
						HASP->Par3=(unsigned short int)-1;
						break;
						}
				
				HASP->Par2=HASPMem[HASP->Par1];
				HASP->Par3=0;
				}
				else
				{
				// Invalid Passwords
				HASP->Par1=HASP->Par2=HASP->Par4=0;
				HASP->Par3=(unsigned short int)-3;
				}
			break;

// if demo...
#ifdef HASP_EMU_DEMO

	case 4:
	case 45:HASP->Par3=0;
		break;
#else
	// MEMOHASP_WRITEWORD
	// NETHASP_WRITEMEMO
	case 4: // Read Header
	case 45:Opened=ReadHeader(HASP->Pass1,HASP->Pass2);
			if (Opened != -1)
				{
				// Param Check
				if (HASP->Par1 > HASPHeader->MemSize/2)
						{
						HASP->Par1=HASP->Par2=HASP->Par4=0;
						HASP->Par3=(unsigned short int)-2;
						break;
						}
				// ReadMemory
				if (ReadMemory(Opened) != 0)
						{
						HASP->Par1=HASP->Par2=HASP->Par4=0;
						HASP->Par3=(unsigned short int)-1;
						break;
						}

				// Change
				HASPMem[HASP->Par1]=HASP->Par2;

				// Write Memory
				if (WriteMemory(Opened) != 0)
						{
						HASP->Par1=HASP->Par2=HASP->Par4=0;
						HASP->Par3=(unsigned short int)-1;
						break;
						}
				

				
				HASP->Par3=0;
				}
				else
				{
				// invalid Passwords
				HASP->Par1=HASP->Par2=HASP->Par4=0;
				HASP->Par3=(unsigned short int)-3;
				}
			break;

#endif


	// LOCALHASP_HASPSTATUS
	//		Undoc. fn.
	case 5: if (HASP->Pass1 == 0 && HASP->Pass2 == 0)
			{
			HASP->Par3=102;
			HASP->Par1=HASP->Par2=HASP->Par3=0;
			}
			else
			// Undoc. fn.
			if (HASP->Pass1 == 5 && HASP->Pass2 == 5)
				HASP->Par1=HASP->Par2=HASP->Par3=HASP->Par4=0;
			else
			{
			// Read Header
			Opened=ReadHeader(HASP->Pass1,HASP->Pass2);
			if (Opened != -1)
				{
				HASP->Par1=HASPHeader->MemType;
				HASP->Par2=HASPHeader->KeyType;
				HASP->Par3=1;
				}
				else
				{
				// Invalid Passwords
				HASP->Par1=HASP->Par2=HASP->Par4=0;
				HASP->Par3=(unsigned short int)-3;
				}
			}
			break;

	// MEMOHASP_HASPID
	// Read Header
	case 6:	Opened=ReadHeader(HASP->Pass1,HASP->Pass2);
			if (Opened != -1)
				{
				HASP->Par1=HASPHeader->HASPID & 0xFFFF;
				HASP->Par2=HASPHeader->HASPID >> 16;
				HASP->Par3=0;
				}
				else
				{
				HASP->Par1=HASP->Par2=HASP->Par4=0;
				HASP->Par3=(unsigned short int)-3;
				}
			break;

	// UNDOC	
	case 11:HASP->Par2=HASP->LPT;
			if (HASP->LPT == 0)
					HASP->Par1=0;
					else
					HASP->Par1=HASP->LPT;
			HASP->Par3=0;
			HASP->Par4=0x246;
			break;
	// UNDOC
	case 12:HASP->Par1=HASP->Par2;
			HASP->Par2=HASP->LPT;
			HASP->Par3=HASP->Pass1;
			HASP->Par4=0x246;
			break;

	// MEMOHASP_READBLOCK
	// NETHASP_READBLOCK
	case 50:	// Read Header 
	case 52:Opened=ReadHeader(HASP->Pass1,HASP->Pass2);
			if (Opened != -1)
				{
				// Param Check
				if ((HASP->Par1 + HASP->Par2)> HASPHeader->MemSize/2)
						{
						HASP->Par1=HASP->Par2=HASP->Par4=0;
						HASP->Par3=(unsigned short int)-2;
						break;
						}
				// Read Memory
				if (ReadMemory(Opened) != 0)
						{
						HASP->Par1=HASP->Par2=HASP->Par4=0;
						HASP->Par3=(unsigned short int)-1;
						break;
						}

				// Copy to Buffer
				EMUMemCpy((char *)HASP->Par4,(char *)HASPMem,HASP->Par2*2);

				
				HASP->Par3=0;
				}
				else
				{
				// Invalid Passwords
				HASP->Par1=HASP->Par2=HASP->Par4=0;
				HASP->Par3=(unsigned short int)-3;
				}
			break;

// if demo...
#ifdef HASP_EMU_DEMO

	case 51:
	case 53:HASP->Par3=0;
		break;

#else

	// MEMOHASP_WRITEBLOCK
	// NETHASP_WRITEBLOCK
	case 51:// Read Header
	case 53:Opened=ReadHeader(HASP->Pass1,HASP->Pass2);
			if (Opened != -1)
				{
				// Param Check
				if ((HASP->Par1 + HASP->Par2)> HASPHeader->MemSize/2)
						{
						HASP->Par1=HASP->Par2=HASP->Par4=0;
						HASP->Par3=(unsigned short int)-2;
						break;
						}
				// Read Memory
				if (ReadMemory(Opened) != 0)
						{
						HASP->Par1=HASP->Par2=HASP->Par4=0;
						HASP->Par3=(unsigned short int)-1;
						break;
						}

				// Change
				EMUMemCpy((char *)HASPMem,(char *)HASP->Par4,HASP->Par2*2);

				// Write It
				if (WriteMemory(Opened) != 0)
						{
						HASP->Par1=HASP->Par2=HASP->Par4=0;
						HASP->Par3=(unsigned short int)-1;
						break;
						}
				
				HASP->Par3=0;
				}
				else
				{
				// Invalid Passwords
				HASP->Par1=HASP->Par2=HASP->Par4=0;
				HASP->Par3=(unsigned short int)-3;
				}
			break;

#endif

	// default
	default:HASP->Par1=HASP->Par2=HASP->Par4=0;HASP->Par3=-999;
	}

	// if Dump opened - close it
	if (Opened != -1)
		if (EMUCloseFile(Opened) == -1)
			HASP->Par1=HASP->Par2=HASP->Par3=HASP->Par4=0;			



}

/****************************************************************************
* EMUStrCpy - string copy                                                   *
****************************************************************************/
char * EMUStrCpy(char *out,char *in)
{
while(in[0] != 0)
{
out[0]=in[0];
in++;
out++;
}
out[0]=0;
return (out);
}


/****************************************************************************
* EMUStrLen - get string len                                                *
****************************************************************************/
unsigned int EMUStrLen(const char *buf)
{
unsigned int len=0;
while(buf[0] != 0)
{
buf++;
len++;
}
return len;
}


/****************************************************************************
* EMUStrCat - string cat                                                    *
****************************************************************************/
char * EMUStrCat(char *out,char *in)
{
char *out2=out+EMUStrLen(out);
EMUStrCpy(out2,in);
return out;
}


/****************************************************************************
* EMUStrNCpy - string n cat                                                 *
****************************************************************************/
char * EMUStrNCat(char *dest,char *src,unsigned int maxlen)
{

char *dest2=dest+EMUStrLen(dest);
unsigned int len;

len = EMUStrLen(src);

if (len > maxlen)
	len = maxlen;

while (len != 0)
{
dest2[0]=src[0];
dest2++;
src++;
len--;
}

return (dest);
}


/****************************************************************************
* EMUMemNCmp - compare 2 mem block                                          *
****************************************************************************/
int EMUMemNCmp(char *dest,char *src,unsigned int maxlen)
{

while (maxlen != 0)
{
if (dest[0] != src[0])
	return 1;
dest++;
src++;
maxlen--;
}

return 0;
}


/****************************************************************************
* EMUMemNCpy - copy 2 mem block                                          *
****************************************************************************/
void EMUMemCpy(char *dest,char *src,unsigned int maxlen)
{

while (maxlen != 0)
{
dest[0]=src[0];
dest++;
src++;
maxlen--;
}

}



/****************************************************************************
* EMUStrUpr - string to upper case                                          *
****************************************************************************/
char * EMUStrUpr(char *str)
{
char *str2=str;
unsigned int len=EMUStrLen(str);
while(len != 0)
{
if ((str2[0] >= 'a') && (str2[0] <= 'z'))
	str2[0]=str2[0]+
len--;
str2++;
}
return (str);
}

/****************************************************************************
* EMUULongToStr - ulong to stryng                                           *
****************************************************************************/
char * EMUULongToStr(unsigned long n,char *str)
{
unsigned int tt;
int t;
str[8]=0;
for(t=7;t>=0;t--)
	{
	tt=n%16;
	n = n>> 4;
	if (tt<=9)
		tt=tt+'0';
		else
		tt=tt+'A'-10;
	str[t]=tt;
	}

return (str);
}


/****************************************************************************
* ReadHeader - read header                                                  *
****************************************************************************/
int ReadHeader(unsigned int Pass1,unsigned int Pass2)
{
int Opened;

unsigned long tmp;

// If demo...
#ifndef HASP_EMU_DEMO
	EMUStrCpy(DUMPFile,DUMPPath);
	tmp=(Pass1 << 16) + Pass2;
	EMUULongToStr(tmp,DUMP);
	EMUStrCat(DUMPFile,DUMP);
	EMUStrCat(DUMPFile,".hsp");
#else
	tmp=(Pass1 << 16) + Pass2;
	EMUULongToStr(tmp,DUMPFile);
#endif

// Open File
Opened=EMUCreateFile(DUMPFile,0);

if (Opened != -1)
{

// Read Header
if (EMUReadFile(Opened,sizeof(EMU_HASP_DATA),0,(unsigned char *)HASPHeader) == -1)
	return -1;

// Check Sign
if (EMUMemNCmp(HASPHeader->Sign,"Soft-Pro HASP Dump\0",19) != 0)
	return -1;

// Check Version
if (HASPHeader->VerHi != VERSION_OF_HASP_EMU_HI || 
	HASPHeader->VerLow != VERSION_OF_HASP_EMU_LOW)
	return -1;

}

return Opened;
}


/****************************************************************************
* ReadMemory - read memory                                                  *
****************************************************************************/
int ReadMemory(int Opened)
{
if (EMUReadFile(Opened,HASPHeader->MemSize,
	HASPHeader->MaxSeed*8+0x38,(unsigned char *)HASPMem) == -1)
	return -1;

return 0;
}

/****************************************************************************
* WriteMemory - Write memory                                                  *
****************************************************************************/
int WriteMemory(int Opened)
{
#ifndef HASP_EMU_DEMO

if (EMUWriteFile(Opened,HASPHeader->MemSize,
	HASPHeader->MaxSeed*8+0x38,(unsigned char *)HASPMem) == -1)
	return -1;
#endif
return 0;
}


